/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.mixinsquared.adjuster;

import com.bawnorton.mixinsquared.adjuster.MixinAnnotationAdjusterRegistrar;
import com.bawnorton.mixinsquared.adjuster.tools.AdjustableAnnotationNode;
import com.bawnorton.mixinsquared.reflection.MixinInfoExtension;
import com.bawnorton.mixinsquared.reflection.StateExtension;
import com.bawnorton.mixinsquared.reflection.TargetClassContextExtension;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomStringUtils;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.logging.ILogger;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.transformer.ext.IExtension;
import org.spongepowered.asm.mixin.transformer.ext.ITargetClassContext;
import org.spongepowered.asm.service.MixinService;

public final class ExtensionAnnotationAdjust
implements IExtension {
    private static final ILogger LOGGER = MixinService.getService().getLogger("mixinsquared-annotation-adjuster");

    public boolean checkActive(MixinEnvironment environment) {
        return true;
    }

    public void preApply(ITargetClassContext context) {
        TargetClassContextExtension.tryAs(context).ifPresent(contextExtension -> {
            SortedSet<IMixinInfo> mixinInfos = contextExtension.getMixins();
            mixinInfos.forEach(mixinInfo -> {
                ClassNode mixinClassNode = mixinInfo.getClassNode(0);
                List targetClassNames = mixinInfo.getTargetClasses().stream().map(s -> s.replaceAll("/", ".")).collect(Collectors.toList());
                String mixinClassName = mixinInfo.getClassName();
                List methodNodes = mixinClassNode.methods;
                methodNodes.forEach(methodNode -> {
                    List visibleAnnotations = methodNode.visibleAnnotations;
                    if (visibleAnnotations == null) {
                        return;
                    }
                    ArrayList<AdjustableAnnotationNode> postAdjust = new ArrayList<AdjustableAnnotationNode>();
                    boolean adjusted = false;
                    for (AnnotationNode annotationNode : visibleAnnotations) {
                        AdjustableAnnotationNode preAdjusted = AdjustableAnnotationNode.fromNode(annotationNode);
                        AdjustableAnnotationNode postAdjusted = MixinAnnotationAdjusterRegistrar.adjust(targetClassNames, mixinClassName, methodNode, preAdjusted, (adjuster, node) -> {
                            LOGGER.debug("Adjuster \"{}\" modified annotation on method \"{}\" in mixinInfo \"{}\"", new Object[]{adjuster, methodNode.name + methodNode.desc, mixinClassName});
                            LOGGER.debug("Pre-adjustment: {}", new Object[]{preAdjusted == null ? "null" : preAdjusted});
                            LOGGER.debug("Post-adjustment: {}", new Object[]{node == null ? "null" : node});
                        });
                        if (postAdjusted != null) {
                            postAdjust.add(postAdjusted);
                        }
                        if (this.equal(preAdjusted, postAdjusted)) continue;
                        LOGGER.warn("Modified mixinInfo \"{}\". Check debug logs for more information.", new Object[]{mixinClassName});
                        adjusted = true;
                    }
                    if (adjusted) {
                        methodNode.name = methodNode.name + String.format("$%s$m2-adjusted", RandomStringUtils.randomAlphanumeric((int)6));
                    }
                    visibleAnnotations.clear();
                    visibleAnnotations.addAll(postAdjust);
                });
                MixinInfoExtension.tryAs(mixinInfo).flatMap(mixinExtension -> StateExtension.tryAs(mixinExtension.getState())).ifPresent(stateExtension -> stateExtension.setClassNode(mixinClassNode));
            });
        });
    }

    private boolean equal(AnnotationNode an1, AnnotationNode an2) {
        if (an1 == null) {
            return an2 == null;
        }
        if (an2 == null) {
            return false;
        }
        if (!an1.desc.equals(an2.desc)) {
            return false;
        }
        if (an1.values == null) {
            return an2.values == null;
        }
        if (an2.values == null) {
            return false;
        }
        if (an1.values.size() != an2.values.size()) {
            return false;
        }
        return an1.values.equals(an2.values);
    }

    public void postApply(ITargetClassContext context) {
    }

    public void export(MixinEnvironment env, String name, boolean force, ClassNode classNode) {
    }
}

